

/**
 ******************************************************************************
 *
 * @file        MG32_Common_API.h
 * @brief       Common H file.
 
 * @par         Project
 *              Gamepad
 * @version     V1.00
 * @date        2022/03/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef __COMMON_API_H
#define __COMMON_API_H



#include "MG32.h"
#include "MG32_GPIO_DRV.h"


/**
 * @name  typedef
 */
///@{

/*! @enum   GPIO_Mode_TypeDef
    @brief  Pin IO mode control options .
*/ 
typedef enum
{
    Analog_Mode          = 0,       /*!< Analog IO*/
    Data_DIR_OUT_QB      = 1,       /*!< Qusi-bidirection output*/
    Data_DIR_OUT_OD_NoRU = 2,       /*!< Open drain output and disable internal pull-up resistance*/
    Data_DIR_OUT_OD_RU   = 3,       /*!< Open drain output with internal pull-up resistance*/
    Data_DIR_OUT_PP      = 4,       /*!< Push pull output.*/
    Data_DIR_IN_NoRU     = 5,       /*!< Digital input and disable internal pull-up resistance.*/
    Data_DIR_IN_RU       = 6,       /*!< Digital input with internal pull up resistance*/
    
}GPIO_Mode_TypeDef;

///@}


/**
 * @name  function
 */
///@{

void GPIO_PinConfig(Pin_Struct* PinName , GPIO_Mode_TypeDef PinMode , uint8_t PinAFS);

///@}

#endif

